<?php
global $currentUser, $VIP_LEVELS;

// VIP লেভেল বের করা
$vipLevel = 0;
foreach (array_reverse($VIP_LEVELS) as $level) {
    if ($currentUser['totalBetAmount'] >= $level['min']) {
        $vipLevel = $level['level'];
        break;
    }
}
?>
<!-- PROFILE VIEW -->
<div id="profile-view">
    <div class="profile-header-card">
        <div class="profile-top">
            <img src="ball_0.webp" class="profile-avatar" alt="Avatar">
            <div class="profile-info">
                <h2 id="p-name"><?php echo htmlspecialchars($currentUser['name']); ?></h2>
                <div class="uid-badge">
                    UID: <span id="p-id"><?php echo $currentUser['uiId']; ?></span>
                    <i class="fas fa-copy" onclick="copyReferral()"></i>
                </div>
                <p id="p-phone">+880 <?php echo htmlspecialchars($currentUser['phone']); ?></p>
            </div>
        </div>
        
        <div class="vip-mini-banner" onclick="showPage('vip')">
            <div class="vip-mini-left">
                <i class="fas fa-crown"></i>
                <span id="profile-vip-badge">VIP <?php echo $vipLevel; ?></span>
            </div>
            <div class="vip-mini-right">
                <span>Privileges</span>
                <i class="fas fa-angle-right"></i>
            </div>
        </div>
    </div>
    
    <div class="quick-actions">
        <div class="q-action" onclick="showPage('deposit')">
            <div class="q-icon bg-green"><i class="fas fa-wallet"></i></div>
            <span>Deposit</span>
        </div>
        <div class="q-action" onclick="showPage('withdraw')">
            <div class="q-icon bg-red"><i class="fas fa-hand-holding-usd"></i></div>
            <span>Withdraw</span>
        </div>
        <div class="q-action" onclick="showPage('wallet')">
            <div class="q-icon bg-blue"><i class="fas fa-coins"></i></div>
            <span>Wallet</span>
        </div>
        <div class="q-action" onclick="showPage('vip')">
            <div class="q-icon bg-gold"><i class="fas fa-crown"></i></div>
            <span>VIP</span>
        </div>
    </div>
    
    <div class="menu-list">
        <div class="menu-item" onclick="showPage('activity')">
            <div class="menu-icon"><i class="fas fa-tasks text-blue"></i></div>
            <span>Activity Center</span>
            <i class="fas fa-chevron-right arrow"></i>
        </div>
        <div class="menu-item" onclick="showPage('promotion')">
            <div class="menu-icon"><i class="fas fa-share-alt text-red"></i></div>
            <span>Promotion / Agency</span>
            <i class="fas fa-chevron-right arrow"></i>
        </div>
        <div class="menu-item" onclick="showPage('gift')">
            <div class="menu-icon"><i class="fas fa-gift text-red"></i></div>
            <span>Redeem Gift Code</span>
            <i class="fas fa-chevron-right arrow"></i>
        </div>
        <div class="menu-item" onclick="logout()">
            <div class="menu-icon"><i class="fas fa-sign-out-alt text-dark"></i></div>
            <span>Logout</span>
            <i class="fas fa-chevron-right arrow"></i>
        </div>
    </div>
</div>